package structure.location;

import java.util.ArrayList;
import java.util.List;

import structure.device.Heater;
import structure.device.Light;
import structure.device.Shutter;

public class Room extends Location {
	private List<Shutter> shutters = new ArrayList<Shutter>();
	private List<Light> lights = new ArrayList<Light>();
	private List<Heater> heaters = new ArrayList<Heater>();

	public List<Shutter> shutters() {
		return shutters;
	}

	public List<Light> lights() {
		return lights;
	}

	public List<Heater> heaters() {
		return heaters;
	}

	public void addShutter(Shutter shutter) {
		shutters().add(shutter);
	}

	public void addLight(Light light) {
		lights().add(light);
	}

	public void addHeater(Heater heater) {
		heaters().add(heater);
	}
}
